/*
 * BoostGraph.cpp
 *
 *  Created on: Jul 17, 2011
 *      Author: dung
 */

#include "BoostGraph.h"


Graph convert(AdjGraph& adjG, int type, double maxPro) {
	Graph g;
	int n = adjG.order();
	Vertex *vertices = new Vertex[n];


	FOR(u, n) {
		vertices[u] = add_vertex(g);
		g[vertices[u]].index = u;
		g[vertices[u]].name = adjG.getName(u);
		//cout << vertex(u, g) << endl;
	}

	if (type == UNIFORM) {
		FOR(u, n) {
			vector<int> neis = adjG.neighbors(u);

			FOR (i, neis.size()) {
				int adjNode = neis[i];
				bool b;
				Edge e;
				tie(e, b) = add_edge(vertices[u], vertices[adjNode], g);
				g[e].weight = 1.0/adjG.getDegree(adjNode);
			}
		}
	} else if (type == RANDOM) {
		srand(time(0));
		FOR(u, n) {
			vector<int> neis = adjG.neighbors(u);

			FOR (i, neis.size()) {
				int adjNode = neis[i];
				bool b;
				Edge e;

				tie(e, b) = add_edge(vertices[u], vertices[adjNode], g);
				g[e].weight = (rand()*maxPro)/RAND_MAX;
			}
		}
	}

	FOR(i, n) {
		Vertex u = vertices[i];
		double in_total = 0;
		pair<in_edge_iterator, in_edge_iterator> inEdges = in_edges(u, g);
		for(; inEdges.first != inEdges.second; ++inEdges.first) {
			Edge e = *inEdges.first;
			in_total = in_total + g[ e ].weight;
		}
		g[ u ].in_total = in_total;
	}

	delete []  vertices;

	return g;
}
