/*
 * Graph.h
 *
 *  Created on: Mar 6, 2010
 *      Author: seven
 */
#include "common.h"
#include <cstdio>
#include <cstdlib>
#include <iostream>
#include <cstdio>
#include <fstream>
#include <cstdlib>
#include <cmath>
#include <map>
#include <iterator>
#include <algorithm>
#include <vector>
#include <sstream>
#include <string>
#include <set>

using namespace std;

#ifndef GRAPH_H_
#define GRAPH_H_

#define UNIFORM_WEIGHT -2
#define RANDOM_WEIGHT -1

class AdjGraph {

private:
	int n;
	FILE *file;
	int *degree;
	int **adj;
	int *adjacentList;
	double **p;
	double *pList;
	int *id2name;
	bool onlineMode;

public:
	AdjGraph(const char *fileName, bool onlineMode);
	AdjGraph(const char *fileName, bool onlineMode, double probability);
	int order();
	int size();
	int getDegree(int);
	vector<int> neighbors(int);
	int getNeighbor(int, int);
	vector<double> probability(int u);
	void writeComFile(char*);
	int getName(int);
	int createCommunityFile(const char*,const char*);
	int createOverlapCommunityFile(const char* comFile,const char* dataName);
	int createSemiOverlapCommunityFile(const char* comFile,const char* dataName);
	bool writeToFile(const char* fileName);
	bool exportTulip(const char* fileName);
	bool exportHcil(const char* dataName, int limit);
	bool exportParjek(const char* fileName);
	virtual ~AdjGraph();
};

#endif /* GRAPH_H_ */
