/*
 * Graph.cpp
 *
 *  Created on: Mar 6, 2010
 *      Author: seven
 */

#include "AdjGraph.h"
#include <time.h>

AdjGraph::AdjGraph(const char *fileName, bool onlineMode) {
	this->onlineMode = onlineMode;
	this->file = file;

	FILE *fin;
	fin = fopen( fileName, "rb");

	fread((void *) &n,sizeof(int),1, fin );
	degree = new int[n];
	fread((void *) degree, sizeof(int),n,fin);
	id2name = new int[n];
	fread((void *) id2name, sizeof(int), n, fin);

	//Read all edges to memory
	if (!onlineMode){
		int sumDegree = 0;
		FOR(i, n)
		sumDegree += degree[i];
		adjacentList = new int[sumDegree];
		fread((void *)adjacentList, sizeof(int), sumDegree, fin );

		adj = new int*[n];

		//	printf("Start");
		adj[0] = adjacentList;
		FOR(u, n-1)
		adj[u+1] = adj[u] + degree[ u ];
		//	printf("Stop");
		//	printf("Reduced graph: Nodes: %d edges: %d \n", n, sumDegree/2);
		//	FOR(u, n) {
		//		printf("Adjacent to %d: ",u);
		//		FOR(j, degree[u])
		//		printf("%d ", adj[u][j]);
		//		printf("\n");
		//	}
		fclose(fin);
	}else
		this->file = fin;
}

/*
 * The weight of edges depends on the probability parameters
 * 0< probability < 1: all edges have weight probability
 * -1 : random weight from 0 to 1
 * -2 : uniform edge weight, equal 1/dv
 */
AdjGraph::AdjGraph(const char *fileName, bool onlineMode, double probability) {
	this->onlineMode = onlineMode;
	this->file = file;

	FILE *fin;
	fin = fopen( fileName, "rb");

	fread((void *) &n,sizeof(int),1, fin );
	degree = new int[n];
	fread((void *) degree, sizeof(int),n,fin);
	id2name = new int[n];
	fread((void *) id2name, sizeof(int), n, fin);

	//Read all edges to memory
	if (!onlineMode){
		int sumDegree = 0;
		FOR(i, n)
		sumDegree += degree[i];

		adjacentList = new int[sumDegree];
		fread((void *)adjacentList, sizeof(int), sumDegree, fin );

		adj = new int*[n];
		adj[0] = adjacentList;
		FOR(u, n-1){
			adj[u+1] = adj[u] + degree[ u ];
		}

		pList = new double[sumDegree];
		p = new double*[n];
		p[0] = pList;
		FOR(u, n-1){
			p[u+1] = p[u] + degree[u];
		}

		// Assign weight to edges
		if (0<= probability && probability <=1) {
			FOR(i, sumDegree) {
				pList[i] = probability;
			}
		} else if (probability == RANDOM_WEIGHT) {
			srand(time(0));
			FOR(i, sumDegree) {
				pList[i] = (rand()*1.0)/RAND_MAX;
			}
		} else if (probability == UNIFORM_WEIGHT) {
			FOR (u, n){
				FOR(i, degree[u]){
					p[u][i] = 1.0/degree[adj[u][i]];
				}
			}
		}

		adj[0] = adjacentList;
		p[0] = pList;

		fclose(fin);
	}else
		this->file = fin;
}

int AdjGraph::order(){
	return n;
}

int AdjGraph::size(){
	int totalDegree = 0;

	FOR(u, n)
	totalDegree += degree[ u ];

	return totalDegree/2;
}

int AdjGraph::getDegree(int u){
	return degree[u];
}

vector<int> AdjGraph::neighbors(int u){
	vector<int> neis;
	neis.reserve( degree[u] );

	FOR(i, degree[ u ]) {
		neis.push_back( adj[ u ][ i ] );
	}
	return neis;
}

vector<double> AdjGraph::probability(int u){
	vector<double> prob;
	prob.reserve( degree[u] );

	FOR(i, degree[ u ])
	prob.push_back( p[ u ][ i ] );

	return prob;
}

void AdjGraph::writeComFile(char* fileName){
	FILE *fo = fopen(fileName, "wb");
	if (!fo){
		cerr << "Error: File access denied."<< endl;
		return;
	}

	for (int i=1;i<n;i++){
		degree[ i ] += degree[ i - 1 ];
	}
	printf("degree n %d", degree[n-1]);
	int c1 = fwrite((void *) &n, sizeof(int), 1, fo);
	int c2  = fwrite((void *) degree, sizeof(int), n, fo);
	int c3 =fwrite((void *) adjacentList, sizeof(int), degree[ n-1 ], fo);
	printf("%d %d %d", c1, c2, c3);
	fclose(fo);
}

bool AdjGraph::writeToFile(const char* fileName){
	FILE *fo = fopen(fileName, "wb");
	if (!fo){
		cerr << "Error: File access denied."<< endl;
		return false;
	}

	int m = 0;
	for (int i=0;i<n;i++){
		m += degree[ i ];
		//id2name[i] = i;
	}
	printf("degree n %d", degree[n-1]);
	int c1 = fwrite((void *) &n, sizeof(int), 1, fo);
	int c2  = fwrite((void *) degree, sizeof(int), n, fo);
	int c4 = fwrite((void *) id2name, sizeof(int), n, fo);
	int c3 =fwrite((void *) adjacentList, sizeof(int), m, fo);
	if (c1 + c2 + c3 + c4 < 1 + n + n + m){
		return false;
	}

	fclose(fo);
	return true;
}
bool AdjGraph::exportTulip(const char* fileName){
	FILE *fo = fopen(fileName, "w");
	if (!fo){
		cerr << "Error: File access denied."<< endl;
		return false;
	}

	fprintf(fo, "(tlp \"2.0\"\n");
	fprintf(fo, "; %d nodes and %d edges\n", n, this->size());

	fprintf(fo, "(nodes ");
	int m = 0;
	for (int i=0;i<n;i++){
		fprintf(fo, "%d ", i);
	}
	fprintf(fo, ")\n");

	int e = 0;
	for (int u=0; u < n; ++u)
		for (int v = 0; v < degree[ u ]; ++v){
			fprintf(fo, "(edge %d %d %d)\n", e, u, v);
			e++;
		}
	fprintf(fo, ")");

	fclose(fo);
	return true;
}

bool AdjGraph::exportHcil(const char* dataName, int limit){
	char name[50];
	sprintf(name, "%sNode.txt", dataName);
	FILE *fo = fopen( name, "w");
	if (!fo){
		cerr << "Error: File access denied."<< endl;
		return false;
	}

	fprintf(fo, "ID\n");
	fprintf(fo, "INTEGER\n");

	for (int i=0;i<limit;i++){
		fprintf(fo, "%d\n", i);
	}
	fclose(fo);

	sprintf(name, "%sEdge.txt", dataName);
	fo = fopen(name, "w");
	if (!fo){
		cerr << "Error: File access denied."<< endl;
		return false;
	}

	fprintf(fo, "ID1\tID2\n");
	fprintf(fo, "INTEGER\tINTEGER\n");
	for (int u=0; u < limit; ++u)
		for (int v = 0; v < degree[ u ]; ++v){
			if (adj[u][v] < limit)
				fprintf(fo, "%d\t%d\n", u, adj[ u ][ v ]);
		}
	fclose(fo);
	return true;
}

bool AdjGraph::exportParjek(const char* fileName){
	FILE *fo = fopen( fileName, "w");
	if (!fo){
		cerr << "Error: File access denied."<< endl;
		return false;
	}

	fprintf(fo, "*Vertices %d\n", n);
	for (int i=0;i<n;i++){
		fprintf(fo, "%d \"%d\"\n", i + 1, i + 1);
	}
	//fprintf(fo, "*Arcs\n");
	fprintf(fo, "*Edges %d\n", size());
	for (int u=0; u < n; ++u)
		for (int v = 0; v < degree[ u ]; ++v){
			if (u < adj[u][v])
				fprintf(fo, "%d %d\n", u + 1, adj[u][v] + 1);
		}
	fclose(fo);
	return true;
}
int AdjGraph::createCommunityFile(const char* comFile,const char* dataName){
	//printf("in");
	FILE *fin = fopen(comFile, "r");
	FILE **fo ;
	if (!fin){
		cerr << "Error: File access denied."<<endl;
		return -1;
	}
	//printf(" de1");
	int *com = new int[ n ];
	int node, community;

	while (!feof(fin)){
		node = -1, community = -1;
		fscanf(fin, "%d %d", &node, &community);
		if ( node + community > 0 ) com[ node ] = community;
	}
	fclose(fin);
	//printf(" de2");
	int max = 0;
	FOR( i, n)
	max = MAX( com[ i ], max);
	max++;
	fo = new FILE*[ max ];
	//printf(" de3");
	char filename[30];
	FOR (i, max){
		sprintf(filename, "%sCOM%d.txt", dataName, i);
		fo[ i ] = fopen(filename, "w");
		if (!fo[ i ]){
			cerr << "Error: File access denied."<<endl;
			return -1;
		}
	}
	//printf(" de4 max %d", max);
	int e = 0;
	FOR (u, n){
		FOR (i, degree[ u ]){
			int v = adj[ u ][ i ];
			//printf("v %d %d\n", com[ u ], degree[u]);
			//printf("fis %d %d\n", com[u], com[v]);
			if (com[ u ] == com[ v ])
			{
				e++;
				fprintf(fo[ com[u] ], "%d %d\n", u, v);
			}
			//	printf("fis1\n");
		}
	}
	printf(" %d number of edge", e);

	FOR (i, max)
	fclose(fo[ i ]);
	/*
	FOR (u, n){
		FOR (i, degree[ u ]){
			int v = adj[ u ][ i ];
			if (com[ u ] == com[ v ] && com[u] >= 150)
				//printf("%d\n", com[ u ]);
				fprintf(fo[ com[u] - 1 ], "%d %d\n", u, v);
		}
	}
	for (int i=149; i< max;i++)
		fclose(fo[ i ]);
	 */
	delete [] com;
	delete fo;
	printf(" de6");
	return max;
}

int AdjGraph::createOverlapCommunityFile(const char* comFile,const char* dataName){
	//printf("in");
	FILE *fin = fopen(comFile, "r");
	FILE **fo ;
	if (!fin){
		cerr << "Error: File access denied."<<endl;
		return -1;
	}
	//printf(" de1");
	int *com = new int[ n ];
	int node, community;

	while (!feof(fin)){
		node = -1, community = -1;
		fscanf(fin, "%d %d", &node, &community);
		if ( node + community > 0 ) com[ node ] = community;
	}
	fclose(fin);
	//printf(" de2");
	int max = 0;
	FOR( i, n)
	max = MAX( com[ i ], max);
	max++;
	fo = new FILE*[ max ];
	//printf(" de3");
	char filename[30];
	FOR (i, max){
		sprintf(filename, "%sCOM%d.txt", dataName, i);
		fo[ i ] = fopen(filename, "w");
		if (!fo[ i ]){
			cerr << "Error: File access denied."<<endl;
			return -1;
		}
	}
	//printf(" de4 max %d", max);
	int e = 0;
	FOR (u, n){
		FOR (i, degree[ u ]){
			int v = adj[ u ][ i ];
			//printf("v %d %d\n", com[ u ], degree[u]);
			//printf("fis %d %d\n", com[u], com[v]);
			if (com[ u ] == com[ v ])
			{
				e++;
				fprintf(fo[ com[u] ], "%d %d\n", u, v);
			}
			else{
				fprintf(fo[ com[u] ], "%d %d\n", u, v);
				fprintf(fo[ com[v] ], "%d %d\n", u, v);
			}
			//	printf("fis1\n");
		}
	}
	printf(" %d number of edge", e);

	FOR (i, max)
	fclose(fo[ i ]);
	/*
	FOR (u, n){
		FOR (i, degree[ u ]){
			int v = adj[ u ][ i ];
			if (com[ u ] == com[ v ] && com[u] >= 150)
				//printf("%d\n", com[ u ]);
				fprintf(fo[ com[u] - 1 ], "%d %d\n", u, v);
		}
	}
	for (int i=149; i< max;i++)
		fclose(fo[ i ]);
	 */
	delete [] com;
	delete fo;
	printf(" de6");
	return max;
}

//Every edges is add to subgraphs but only belong to from community
int AdjGraph::createSemiOverlapCommunityFile(const char* comFile,const char* dataName){
	//printf("in");
	FILE *fin = fopen(comFile, "r");
	FILE **fo ;
	if (!fin){
		cerr << "Error: File access denied."<<endl;
		return -1;
	}
	printf(" de1");
	int *com = new int[ n ];
	int node, community;

	while (!feof(fin)){
		node = -1, community = -1;
		fscanf(fin, "%d %d", &node, &community);
		if ( node + community > 0 ) com[ node ] = community;
	}
	fclose(fin);
	printf(" de2");
	int max = 0;
	FOR( i, n)
	max = MAX( com[ i ], max);
	max++;
	fo = new FILE*[ max ];
	printf(" de3 %d", max);
	char filename[100];
	FOR (i, max){
		sprintf(filename, "%sCOM%d.txt", dataName, i);
		printf(" %s \n", filename);
		//fo[ i ] = fopen(filename, "w");
		//if (!fo[ i ]){
		//	cerr << "Error: File access denied."<<endl;
		//	return -1;
		//}
		//fclose(fo[ i ]);
	}
	FILE *fout;

	printf(" de4 max %d", max);
	int e = 0;
	FOR (u, n){
		FOR (i, degree[ u ]){
			int v = adj[ u ][ i ];
			//printf("v %d %d\n", com[ u ], degree[u]);
			//printf("fis %d %d\n", com[u], com[v]);
			if (u > v)
				continue;
			sprintf(filename, "%sCOM%d.txt", dataName, com[ u ]);
			fout = fopen(filename, "a");
			if (com[ u ] == com[ v ])
			{
				e++;

				//fprintf(fo[ com[u] ], "%d %d\n", u, v);
				fprintf(fout, "%d %d\n", u, v);
			}
			else{
				if (u < v)
					//fprintf(fo[ com[u] ], "%d %d\n", u, v);
					fprintf(fout, "%d %d\n", u, v);
				else
					//fprintf(fo[ com[v] ], "%d %d\n", u, v);
					fprintf(fout, "%d %d\n", u, v);
			}
			fclose(fout);

			//	printf("fis1\n");
		}
	}
	printf(" %d number of edge", e);

	//FOR (i, max)
	//	fclose(fo[ i ]);
	/*
	FOR (u, n){
		FOR (i, degree[ u ]){
			int v = adj[ u ][ i ];
			if (com[ u ] == com[ v ] && com[u] >= 150)
				//printf("%d\n", com[ u ]);
				fprintf(fo[ com[u] - 1 ], "%d %d\n", u, v);
		}
	}
	for (int i=149; i< max;i++)
		fclose(fo[ i ]);
	 */
	delete [] com;
	delete fo;
	printf(" de6");
	return max;
} //End of semi overlap

int AdjGraph::getName(int id){
	return id2name[ id ];
}
/*
 * get jth neighbor of vertex i
 */
int AdjGraph::getNeighbor(int i, int j){
	return adj[i][j];
}
AdjGraph::~AdjGraph() {
	// TODO Auto-generated destructor stub
	if (degree) delete [] degree;
	//FOR(i, n)
	//delete [] adj[i];
	if (id2name) delete [] id2name;
	if (adjacentList) delete [] adjacentList;
	//if (adj) delete [] adj;
	if (pList) delete [] pList;
	//if (p) delete [] p;
}


