//==========================================================================================//
// Name        : AFOCS.cpp                                                                  //
// Author      : Nam Nguyen                                                                 //
// Copyright   : 2012                                                                       //
// Description : Algorithm for detecting overlapping community structure on social networks //
// Paper:                                                                                   //
// Overlapping Communities in Dynamic Networks: Their Detection and Mobile Applications     //
// Nam P. Nguyen, Thang N. Dinh, Sindhura Tokala and My T. Thai                             //
// The 17th Int. Conf. on Mobile Computing and Networking (MOBICOM) 2011                    //
//==========================================================================================//
#include "prototypes.h"
//==========================================================================================//
extern double OVERLAP_THRESHOLD;
//==========================================================================================//
int main(int argc, char* args[]) {
	if (argc < 2) {
		cout <<"Usage: AFOCS <the_first_snapshot> <number_of_snapshots> <overlapping_threshold>"<<endl;
		cout <<"Example: afocs facebook_0.txt 25 0.7"<<endl;
		return 0;
	}
	uint numFile = atoi(args[2]); // get number of input files
	if (numFile <= 0) {
		cout <<"Usage: <number_of_snapshots> must be a possitive integer"<<endl;
		return 0;
	}
	char base_file[1000], file_path[1000];
	strcpy_s(base_file, args[1]); // get the root file (the first snapshot)
	string s(args[1]);
	s = s.substr(0, s.find_last_of('_') + 1);
	strcpy_s(file_path, s.c_str() ); // get the path
	OVERLAP_THRESHOLD = atof(args[3]); // get the input overlapping threshold	
	/*******************************************/
	doAFOCS(base_file, file_path, numFile); // doing AFOCS
	/*******************************************/
	return 1;
}
