// strip DL distance score algorithm
// Input: Mseq, Nseq, size m, n

#define min(a,b) (a<b?a:b)
#define least(a,b,c,d) (min( min(a,b), min(c,d) ) )

extern int alphabetaSize;
extern int* alpha;

// n1 is shifting coordinate
void calculateDLScore_bystrip(int *Mseq, int *Nseq, int m, int n, int n1, int **VVV, int* n_id_c, int maxdist)
{
	// n_id_c : mapping of current strip, p_id_x mapping of last strip
	int **DDDSP;
	int **DDD, *id_r, *p_id_c, id_c; // DDD: full score matrix, id_r: mapping alpha to latest row id, id_c: mapping alpha to latest column id
	int i, j, k, l;
	int temp, swap, up, diag, left; //left: insert, up: delete, diag: Match
	int ai, bj, cmp; // position in subMatrix;  
	int *r, *r1, *p; //private pointer
	int savedleft;

	// make a copy of id_c since it will be overwitten.
	p_id_c = (int*)calloc((alphabetaSize + 1), sizeof(int));
	for (i = 0; i <alphabetaSize + 1; i++)
	{
		p_id_c[i] = n_id_c[i];// save previous id c from previous strip.
	}
	// set new idc 
	for (j = 1; j <= n; j++)
	{
		bj = Nseq[j - 1];
		n_id_c[bj] = j + n1; // not good for the parallel.
	}
 
	// Declare space for DDD, id_r, id_c
	DDDSP = (int **)calloc((alphabetaSize + 1), sizeof(int*));
	DDD = (int **)calloc((alphabetaSize + 1), sizeof(int*));
	for (i = 0; i <alphabetaSize + 1; i++)
	{
		DDDSP[i] = (int*)calloc((n + 2), sizeof(int));  // set as 0
		DDD[i] = DDDSP[i] + 1;

		r = DDDSP[i];
		for (j = 0; j <n + 2; j++)
		{
			r[j] = maxdist;
		}
	}


	id_r = (int*)calloc((alphabetaSize + 1), sizeof(int));

	// Initialize the first row.
	r = DDD[0];
	for (j = 0; j <= n; j++)
	{
		r[j] = j + n1;
	}
	VVV[0][0] = n + n1;

	// calculate other rows
	for (i = 1; i <= m; i++)
	{
		ai = Mseq[i - 1];

		p = DDD[ai]; // give the space
		DDD[ai] = r1 = r; // save the previous row, this value could not be used
		r = p; // new current row with old value.
		id_c = p_id_c[ai];  // map alphabeta to column id

		savedleft = r[0];
		diag = r1[0]; // previous row 
		r[0] = temp = VVV[0][i]; // copy previous value from last strip.

		// process each column
		for (j = 1; j <= n; j++)
		{
			bj = Nseq[j - 1];
			k = id_r[bj]; l = id_c;

			cmp = 0;
			if (ai == bj)
			{
				cmp = 1;
				id_c = j + n1;
			}
			up = r1[j] + 1; // up
			left = temp + 1;
			diag += 1 - cmp;
			swap = (l < n1 + 1 ? VVV[ai][k - 1] : DDD[bj][l - n1 - 1]) + (i - k - 1) + 1 + (j + n1 - l - 1);
			temp = least(up, left, diag, swap);
		 
			// before save current value into row, lets first recalculate VVV
			k = id_r[ai];   // save previous ai row
			if (  n_id_c[bj] == j + n1) // last column of this strip
			{ 
				VVV[bj][k - 1] = savedleft; // previous ai data which is saved in DDD[ai] , now is r.
			}
			savedleft = r[j];
			r[j] = temp;
			diag = up - 1;
		}

		// writing
		VVV[0][i] = temp; // save last column to VVV so it can be passed to next strip.
		id_r[ai] = i; // map alphabeta to row id 
	}

	for (i = 0; i < alphabetaSize; i++)
	{
		ai = alpha[i];
		k = id_r[ai];
		 
		for (j = 0; j < alphabetaSize; j++)
		{
			bj = alpha[j];
			l = n_id_c[bj];
			if (l > n1)
			{
				VVV[bj][k - 1] = DDD[ai][l - n1 - 1];
			}
		}
	}
}

int calculateDLScore(int *Mseq, int *Nseq, int m, int n, int stripW)
{
	int i, j;
	int n1, n2;
	// Two supporting matrix to pass the data from one strip to another.
	int **VVV, *id_c;
	int **VVVSP, maxdist, *r;

	maxdist = m + n + 1;

	VVVSP = (int **)calloc((alphabetaSize + 1), sizeof(int*));
	VVV = (int **)calloc((alphabetaSize + 1), sizeof(int*));
	for (i = 0; i <alphabetaSize + 1; i++)
	{
		VVVSP[i] = (int*)calloc((m + 2), sizeof(int));  // set as 0
		VVV[i] = VVVSP[i] + 1;

		r = VVVSP[i];
		for (j = 0; j <m + 2; j++)
		{
			r[j] = maxdist;
		}
	}

	id_c = (int*)calloc(alphabetaSize + 1, sizeof(int));

	r = VVV[0];
	// first column
	for (i = 0; i < m + 1; i++)
	{
		r[i] = i;
	}

	// second column
	for (j = 1; j <= n; j += stripW)
	{
		n1 = j;
		n2 = j + stripW - 1; // left, right
		if (n2 > n)
			n2 = n;
		// add one col for previous value.
		calculateDLScore_bystrip(Mseq, Nseq + n1 - 1, m, n2 - n1 + 1, n1 - 1, VVV, id_c, maxdist);
	}
	return VVV[0][m];
}
