#include <stdio.h>
#include <stdlib.h>
#include <memory.h>
#include <time.h>   
  
#define INIT_BUFFER_SIZE 10 
 
 extern int alphabetaSize;
 int alphabeta[128];
 
//transformation from amino acid ascii characters to numbers
//acids are denoted by their index instead of real ascii characters

char anti_trans[26] = {'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K',
	'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V',
	'W', 'X', 'Y', 'Z'}; 
	
int amino_acids_trans[128] = {
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, // 16
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, // 32
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, // 48
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, // 64
	-1,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, // ==>65
	16, 17, 18, 19, 20, 21, 22, 23, 24, 26, -1, -1, -1, -1, -1, -1,
	-1,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, // ==>65
	16, 17, 18, 19, 20, 21, 22, 23, 24, 26, -1, -1, -1, -1, -1, -1
};

/////////////////////////////////////////////////////////////////

inline int map( int x)
{
	int i =0;
	for( i =0; i < alphabetaSize; i++)
	{
		if( alphabeta[i] == x)
			break;
	}
	if( i == alphabetaSize )
	{
		alphabeta[alphabetaSize] = x;
		alphabetaSize++;
		amino_acids_trans[x] =  alphabetaSize;
	}
	return i;
}

//read one sequence into host memory
int *readSequence (int *pLen, char *fileName)
{
	int cnt = 0;
	char ch;
    int sizeLimit = INIT_BUFFER_SIZE;
	int *temp;
	int *h_Mem;
	int idx = 0;
	
	h_Mem = (int *)malloc(sizeLimit*sizeof(int));
	FILE *ptrFile;
	if (!(ptrFile=fopen (fileName, "rt")))
	{
		printf ("File %s opening failed!\n", fileName);
		exit(1);
	}

	while ((ch=fgetc(ptrFile))=='\r' || ch=='\n');

	if (ch!= '>' || ch ==EOF)
	{
		printf ("%s: Invalid fasta file format!\n", fileName);
		fclose (ptrFile);
		exit(1);
	}

	for (; ch!='\n' ; ch=fgetc(ptrFile) );

	while ((ch=getc(ptrFile)) != EOF )
	{
		if (ch == '>' )
		{
			for (; ch != '\n'; ch = fgetc(ptrFile));
			continue;
		}
		
        if (cnt>= sizeLimit)
        {
            sizeLimit = sizeLimit*2;
            temp = (int *)malloc(sizeLimit*sizeof(int));
            memcpy (temp, h_Mem, cnt*sizeof(int));
            free (h_Mem);
            h_Mem = temp;
        }

		if (ch=='\r' || ch=='\n' || ch=='N')
			continue;

		if (ch< 0)
		{
			*(h_Mem+cnt) = -1;
		}
		else
		{
		    idx = map((int)ch);
			*(h_Mem+cnt) = (int)amino_acids_trans[(int)ch];
		}
		cnt++;
	}

    *pLen = cnt;

	fclose (ptrFile);

	return h_Mem;
}