// LowranceWagnerAlg DL distance score algorithm
// Input: Mseq, Nseq, size m, n

#define min(a,b) (a<b?a:b)
#define least(a,b,c,d) (min( min(a,b), min(c,d) ) )

extern int num_thread;
extern int alphabetaSize;
 
void calculateDLScore_Parallel( int *Mseq, int *Nseq, int m, int n, int **DDD)
{
	int *id_r, *p_r, id_c; 
	int i, j, k, l;
	int temp, swap, up, diag, left, maxdist; //left: insert, up: delete, diag: Match
	int ai, bj, cmp; // position in subMatrix;  
	int *r, *r1; //private pointer
	int singalW, currSingal, RSingleID, SSingleID; 
	int *singal;
	
	singalW = n/num_thread+1;
	singal = (int *) calloc( (n+2), sizeof(int)); 
	 
	id_r = (int*) calloc ( (alphabetaSize+1), sizeof(int) ); 
	for( i =1; i < alphabetaSize+1; i++)
	{
		id_r[i] = 1; // initialize 1
	}
	
	// Initialize the first row, -1 row
	maxdist = m+n+1;
	r1 = DDD[0];
	r = DDD[1];
	
	#pragma omp parallel for schedule(static) private(i)
	for( i=0; i <= n+1; i++)
	{
		r1[i] = maxdist ; //  max value.
 		r[i] = i-1; // shift one value
	}
	r[0] = maxdist;
	
	#pragma omp parallel for schedule(static,1) ordered private(i, j, ai, bj, cmp, up, left, diag, swap, temp, r1, r, p_r, id_c, k, l, currSingal, RSingleID, SSingleID) firstprivate(singalW, alphabetaSize)
	for( i = 2; i < m+2; i++ )
	{
		// code is controlled by column 0
		RSingleID = SSingleID = 1;
		while (1){
			#pragma omp flush (singal)
			#pragma omp atomic read
			currSingal= singal[RSingleID];
			if (currSingal == i-2) break; // row i starts process
		}
		RSingleID += singalW;

		ai = Mseq[i-2]; //
		// make a copy
		p_r = (int*) calloc ( (alphabetaSize+1), sizeof(int) ); 
		for( j = 0; j < alphabetaSize+1; j++ )
		{
			p_r[j] = id_r[j];
		}
		id_r[ai] = i; // map alphabeta to row id	
		 
		r1 = DDD[i-1]; // previous row
		r = DDD[i]; // current row.
		r[0] = maxdist;
		
		id_c = 1;     // map alphabeta to column id
		
		diag = i-2; // diag
		r[1] = temp = i-1; // left
		
		// process each column
		for( j = 2 ; j < n+2; j++ )
		{
			if( j == RSingleID)
			{
				while (1){
					#pragma omp flush (singal)
					#pragma omp atomic read
					currSingal= singal[RSingleID];
					if (currSingal == i-2) break; // row i starts process
				}
				RSingleID += singalW;
			}
			
			
			bj = Nseq[j-2];
			k = p_r[bj]; l = id_c;
			cmp = 0;
			if( ai == bj )
			{
				cmp = 1;
				id_c = j;
			} 
			
			up =  r1[j] +1; // up
			left = temp +1;
			diag += 1-cmp;
			swap = DDD[k-1][l-1]+ (i- k -1) + 1 + (j - l - 1);
			r[j] = temp = least( up, left, diag, swap) ;
			
			diag = up-1;   
			
			if( j==n+1 || j == SSingleID + singalW -1)
			{
				#pragma omp flush
				#pragma atomic write
				singal[SSingleID]++;
				#pragma omp flush (singal)
				SSingleID += singalW;
			} 	
		} 		
	} 
	
	//return DDD[m][n];
}

void RetrievePath( int *Mseq, int *Nseq, int m, int n, int **DDD, int* path)
{	
	int i, j, k, l;
	int ai, bj, cmp;  
	i = m;
	j = n;
			 
	while( i !=0 && j!=0)
	{
		ai = Mseq[i-1];
		bj = Nseq[j-1];
		cmp = (ai == bj ?1:0);
		if(   DDD[i][j] +1-cmp == DDD[i+1][j+1] ) // diagonal
		{
			path[i-1+j-1] = i-1;
			i = i-1; j=  j-1;
		}
		else if( DDD[i+1][j] +1 == DDD[i+1][j+1] )
		{	
			path[i+j-1] = i;
			i = i; j=  j-1;
		}
		else if( DDD[i][j+1] +1 == DDD[i+1][j+1] ) // up{
		{
			path[i-1+j] = i-1;
			i = i-1; j=  j;		
		}
		else if(!cmp) // swap
		{
			for( k = i;k>=0; k--)
			{
				if(Mseq[k-1] == bj )
					break;
			}
			for( l= j;l>=0; l--)
			{
				if(Nseq[l-1] == ai )
					break;
			}
			if( k == 0 || l==0)
			{
				printf(" Impossible \n");
				exit(0);
			}
			else
			{
				path[ k-1 +  l-1 ] = k-1;
				i = k-1; j=  l-1;
			}
		}
	}
}

int calculateDLTrace_parallel (int *Mseq, int *Nseq, int m, int n, int *path)
{ 
	int i;
	int **DDD;
	
	omp_set_num_threads( num_thread );
	
	// Declare space for DDD, id_r, id_c
	// Add one extra array.
	DDD = (int **) calloc( (m+2), sizeof(int*) );
	for(i=0; i <m+2; i++)
	{
		DDD[i] = (int*) calloc( (n+2), sizeof(int) );  // set as 0
	}
	
	calculateDLScore_Parallel( Mseq, Nseq, m, n, DDD);
	RetrievePath( Mseq, Nseq, m, n, DDD, path);
	
	return DDD[m+1][n+1];
	 
}
