#include <stdio.h>
#include <stdlib.h> 
#include <string.h>
#include <memory.h>
//////////////////////////////// OpenMP
#include <omp.h>
#include "LowranceWagnerAlgTraceParallel.h" // actual algorithm
#include "ReadSeq.h"

#define MAX_FILE_NAME_LENGTH 128
#define INIT_BUFFER_SIZE 10 
#define INF -9999999

int alphabetaSize  = 0; 
int num_thread = 4;

void VerifyPath(int *Mseq, int *Nseq, int m, int n, int* path)
{
	int minValue=0;
	int prei = 0,prej = 0;
	int d,i,j, tempL;
	for( d = 0; d < (m+n+1); d++ )
	{
		i = *(path+d);
		if(i >=0)
		{
			j = d-i;
			if( i-prei == 1 && j-prej ==1)
			{
				if( Mseq[i-1] != Nseq[j-1])
					minValue++;
			}
			else if( j == prej)
			{
				minValue+=i-prei;
			}
			else if(  i== prei)
			{
				minValue+=j-prej ;
			}
			else 
			{
				if( Mseq[i-1] != Nseq[prej] || Mseq[prei]!= Nseq[j-1] )
				{
					printf(" i, j , pi, pj %d %d %d %d m n %d %d %d %d\n", i, j, prei, prej, Mseq[i-1], Nseq[j-1] , Mseq[prei],  Nseq[prej] );
					printf(" Something is not correct!\n");
					exit(1);
				}
				minValue += (i-prei-1-1)+1+(j-prej-1-1);
			}
			prei = i;
			prej = j;
		}
	}
	
	i = m;
	j=n;
	if( i-prei == 1 && j-prej ==1)
	{
		if( Mseq[i-1] != Nseq[j-1])
			minValue++;
	}
	else if( j == prej)
	{
		minValue+=i-prei;
	}
	else if(  i== prei)
	{
		minValue+=j-prej ;
	}
	else 
	{
		if( Mseq[i-1] != Nseq[prej] || Mseq[prei]!= Nseq[j-1] )
		{
			printf(" i, j , pi, pj %d %d %d %d m n %d %d %d %d\n", i, j, prei, prej, Mseq[i-1], Nseq[j-1] , Mseq[prei],  Nseq[prej] );
			printf(" Something is not correct!\n");
			exit(1);
		}
		minValue += (i-prei-1-1)+1+(j-prej-1-1);
	}
	printf("Path generated successfully\n");
}


//////////////////////////////////////////////////////////////////////////////////////
int algMaster(char* filename1, char * filename2)
{
	int i;
	char *h_Query, *h_DB;
	int lenQuery = 0, lenDB = 0;
	double start, end;
	
	int m, n, tempL;
	int *Mseq, *Nseq, *tempSeq; 
	int minScore, pid; 
	
	int *path;
	// read both sequences
	Mseq = readSequence ( &m, filename1);
	Nseq = readSequence ( &n, filename2);
	path = (int *)calloc( (m+n+1), sizeof(int));
	for( i = 0; i <m+n+1; i++)
		path[i] = -1;
	
	
	printf("Parallel DL trace: LowranceWagnerAlg seq1 length=%d seq2 length=%d\n", m, n);
	printf("Alphabeta (size %d): ", alphabetaSize);
	for( i=0; i < alphabetaSize; i++ )
	{
		printf("%c,%d;", alphabeta[i], amino_acids_trans[(int)alphabeta[i]] );
	}
	printf("\n");
	
	// if sequence 1's length is less than sequence 2, swap both sequences.
	if( m < n )
	{
		// swap
		tempL = m;
		m=n;
		n=tempL;
		
		tempSeq = Mseq;
		Mseq = Nseq;
		Nseq = tempSeq;
	}
	start = omp_get_wtime();
		minScore = calculateDLTrace_parallel (Mseq, Nseq, m, n, path);
	end = omp_get_wtime(); 
	
	VerifyPath(Mseq, Nseq, m, n, path);
	
	printf ("Parallel DL trace: %d\n", minScore);
	printf ("Calculation Time %f\n", (end - start));
	
	return 0;
}
 
int main(int argc, char* argv[]){
	// seq1, seq2
 	char filename1[1024], filename2[1024];

	if( argc == 4 )
	{
		strcpy(filename1, argv[1]);
		strcpy(filename2, argv[2]); 
		num_thread = atoi( argv[3]);
	} 
	else
	{
		printf(" Usage: ./Alg [filename1] [filename2] [threadCount]\n");
		return 0;
	}

	algMaster(filename1, filename2);  
}

