// LowranceWagnerAlg DL distance trace algorithm
// Input: Mseq, Nseq, size m, n

#define min(a,b) (a<b?a:b)
#define least(a,b,c,d) (min( min(a,b), min(c,d) ) )

 extern int alphabetaSize;
 
void calculateDLScore( int *Mseq, int *Nseq, int m, int n, int **DDD)
{
	int *id_r, id_c; 
	int i, j, k, l;
	int temp, swap, up, diag, left, maxdist; //left: insert, up: delete, diag: Match
	int ai, bj, cmp; // position in subMatrix;  
	int *r, *r1; //private pointer
	  
	id_r = (int*) calloc ( (alphabetaSize+1), sizeof(int) ); 
	for( i =1; i < alphabetaSize+1; i++)
	{
		id_r[i] = 1; // initialize 1
	}
	
	// Initialize the first row, -1 row
	maxdist = m+n+1;
	r1 = DDD[0];
	r = DDD[1];
	for( i=0; i <= n+1; i++)
	{
		r1[i] = maxdist ; //  max value.
 		r[i] = i-1; // shift one value
	}
	r[0] = maxdist;
	
	// calculate other rows
	for( i = 2; i < m+2; i++ )
	{
		ai = Mseq[i-2]; //

		r1 = r; // new previous row
		r = DDD[i]; // new current row.
		r[0] = maxdist;
		
		id_c = 1;     // map alphabeta to column id
		
		diag = i-2; // diag
		r[1] = temp = i-1; // left
		
		// process each column
		for( j = 2 ; j < n+2; j++ )
		{
			bj = Nseq[j-2];
			k = id_r[bj]; l = id_c;
			
			cmp = 0;
			if( ai == bj )
			{
				cmp = 1;
				id_c = j;
			} 
			
			up =  r1[j] +1; // up
			left = temp +1;
			diag += 1-cmp;
			swap = DDD[k-1][l-1]+ (i- k -1) + 1 + (j - l - 1);
			r[j] = temp = least( up, left, diag, swap) ;
			
			diag = up-1; 
		}
		id_r[ai] = i; // map alphabeta to row id			
	} 
	
	//return DDD[m][n];
}

void RetrievePath( int *Mseq, int *Nseq, int m, int n, int **DDD, int* path)
{	
	int i, j, k, l;
	int ai, bj, cmp;  
	i = m;
	j = n;
			 
	while( i !=0 && j!=0)
	{
		ai = Mseq[i-1];
		bj = Nseq[j-1];
		cmp = (ai == bj ?1:0);
		if(   DDD[i][j] +1-cmp == DDD[i+1][j+1] ) // diagonal
		{
			path[i-1+j-1] = i-1;
			i = i-1; j=  j-1;
		}
		else if( DDD[i+1][j] +1 == DDD[i+1][j+1] )
		{	
			path[i+j-1] = i;
			i = i; j=  j-1;
		}
		else if( DDD[i][j+1] +1 == DDD[i+1][j+1] ) // up{
		{
			path[i-1+j] = i-1;
			i = i-1; j=  j;		
		}
		else if(!cmp) // swap
		{
			for( k = i;k>=0; k--)
			{
				if(Mseq[k-1] == bj )
					break;
			}
			for( l= j;l>=0; l--)
			{
				if(Nseq[l-1] == ai )
					break;
			}
			if( k == 0 || l==0)
			{
				printf(" Impossible \n");
				exit(0);
			}
			else
			{
				path[ k-1 +  l-1 ] = k-1;
				i = k-1; j=  l-1;
			}
		}
	}
}

int calculateDLTrace (int *Mseq, int *Nseq, int m, int n, int *path)
{ 
	int i;
	int **DDD;

	// Declare space for DDD, id_r, id_c
	// Add one extra array.
	DDD = (int **) calloc( (m+2), sizeof(int*) );
	for(i=0; i <m+2; i++)
	{
		DDD[i] = (int*) calloc( (n+2), sizeof(int) );  // set as 0
	}
	
	calculateDLScore( Mseq, Nseq, m, n, DDD);
	RetrievePath( Mseq, Nseq, m, n, DDD, path);
	
	return DDD[m+1][n+1];
	 
}
