#include <stdio.h>
#include <stdlib.h> 
#include <string.h>
#include <memory.h>
//////////////////////////////// OpenMP
#include <omp.h>
#include "LowranceWagnerAlgParallel.h" // actual algorithm
#include "ReadSeq.h"

#define MAX_FILE_NAME_LENGTH 128
#define INIT_BUFFER_SIZE 10 
#define INF -9999999

int alphabetaSize  = 0; 
int num_thread = 4;

//////////////////////////////////////////////////////////////////////////////////////
int algMaster(char* filename1, char * filename2)
{
	int i;
	char *h_Query, *h_DB;
	int lenQuery = 0, lenDB = 0;
	double start, end;
	
	int m, n, tempL;
	int *Mseq, *Nseq, *tempSeq; 
	int minScore; 
	// read both sequences
	Mseq = readSequence ( &m, filename1);
	Nseq = readSequence ( &n, filename2);

	printf("Parallel DL score: LowranceWagnerAlg seq1 length=%d seq2 length=%d\n", m, n);
	printf("Alphabeta (size %d): ", alphabetaSize);
	for(i=0; i < alphabetaSize; i++ )
	{
		printf("%c,%d;", alphabeta[i], amino_acids_trans[(int)alphabeta[i]] );
	}
	printf("\n");

	// if sequence 1's length is less than sequence 2, swap both sequences.
	if( m < n )
	{
		// swap
		tempL = m;
		m=n;
		n=tempL;
		
		tempSeq = Mseq;
		Mseq = Nseq;
		Nseq = tempSeq;
	}
	start = omp_get_wtime();
		minScore = calculateDLScore_parallel (Mseq, Nseq, m, n);
	end = omp_get_wtime(); 

	printf ("Parallel DL score: %d\n", minScore);
	printf ("Calculation Time %f\n", (end - start));
	return 0;
}
 
int main(int argc, char* argv[]){
	// seq1, seq2
 	char filename1[1024], filename2[1024];

	if( argc == 4 )
	{
		strcpy(filename1, argv[1]);
		strcpy(filename2, argv[2]);
		num_thread = atoi( argv[3]);
	} 
	else
	{
		printf(" Usage: ./Alg [filename1] [filename2] [threadCount]\n");
		return 0;
	}
	algMaster(filename1, filename2);  
}

