// LowranceWagnerAlg DL distance score algorithm
// Input: Mseq, Nseq, size m, n

#define min(a,b) (a<b?a:b)
#define least(a,b,c,d) (min( min(a,b), min(c,d) ) )

extern int alphabetaSize;
 
int calculateDLScore( int *Mseq, int *Nseq, int m, int n)
{
	int **DDD, *id_r, id_c; // DDD: full score matrix, id_r: mapping alpha to latest row id, id_c: mapping alpha to latest column id
	int i, j, k, l;
	int temp, swap, up, diag, left, maxdist; //left: insert, up: delete, diag: Match
	int ai, bj, cmp; // position in subMatrix;  
	int *r, *r1; //private pointer
	  
	// Declare space for DDD, id_r, id_c 
	DDD = (int **) calloc( (m+2), sizeof(int*) );
	for(i=0; i <m+2; i++)
	{
		DDD[i] = (int*) calloc( (n+2), sizeof(int) );  // set as 0
	}
	id_r = (int*) calloc ( (alphabetaSize+1), sizeof(int) ); 
	for( i =1; i < alphabetaSize+1; i++)
	{
		id_r[i] = 1; // initialize 1
	}
	
	// Initialize the first row, -1 row
	maxdist = m+n+1;
	r1 = DDD[0];
	r = DDD[1];
	for( i=0; i <= n+1; i++)
	{
		r1[i] = maxdist ; //  max value.
 		r[i] = i-1; // shift one value
	}
	r[0] = maxdist;
	
	// calculate other rows
	for( i = 2; i < m+2; i++ )
	{
		ai = Mseq[i-2]; //

		r1 = r; // new previous row
		r = DDD[i]; // new current row.
		r[0] = maxdist;
		
		id_c = 1;     // map alphabeta to column id
		
		diag = i-2; // diag
		r[1] = temp = i-1; // left
		
		// process each column
		for( j = 2 ; j < n+2; j++ )
		{
			bj = Nseq[j-2];
			k = id_r[bj]; l = id_c;
			
			cmp = 0;
			if( ai == bj )
			{
				cmp = 1;
				id_c = j;
			} 
			
			up =  r1[j] +1; // up
			left = temp +1;
			diag += 1-cmp;
			swap = DDD[k-1][l-1]+ (i- k -1) + 1 + (j - l - 1);
			r[j] = temp = least( up, left, diag, swap) ;
			
			diag = up-1;  
		} 

		id_r[ai] = i; // map alphabeta to row id		
	}
	return DDD[m+1][n+1];
}

