// Linear DL distance trace algorithm
// Input: Mseq, Nseq, size m, n


#define min(a,b) (a<b?a:b)
#define least(a,b,c,d) (min( min(a,b), min(c,d) ) )

 extern int alphabetaSize;
 extern int* alpha;

int calculateDLScore( int *Mseq, int *Nseq, int m, int n, int** DDD, int *id_r)
{
	int id_c; // DDD: full score matrix, id_r: mapping alpha to latest row id, id_c: mapping alpha to latest column id
	int i, j, k, l;
	int temp, swap, up, diag, left; //left: insert, up: delete, diag: Match
	int ai, bj, cmp; // position in subMatrix;  
	int *r, *r1, *p; //private pointer
	    
	
	// Initialize the first row.
	r = DDD[0];
	for( j =0; j <= n; j++)
	{
		r[j] = j;
	}
	
	// calculate other rows
	for( i = 1; i <= m; i++ )
	{
		ai = Mseq[i-1];

		id_c = 0;     // map alphabeta to column id
		
		p = DDD[ai]; // give the space
		r1 = DDD[ai] = r; // save the previous row, this value could not be used
		r = DDD[0] = p; // swap 0 and ai.
		
		diag = i-1; // diag
		r[0] = temp = i; // left
		
		// process each column
		for( j = 1 ; j <= n; j++ )
		{
			bj = Nseq[j-1];
			k = id_r[bj]; l = id_c;
			
			cmp = 0;
			if( ai == bj )
			{
				cmp = 1;
				id_c = j;
			} 
			up =  r1[j] +1; // up
			left = temp +1;
			diag += 1-cmp;
			swap = DDD[bj][l-1]+ (i- k -1) + 1 + (j - l - 1);
			r[j] = temp = least( up, left, diag, swap) ;
			
			diag = up-1;
		} 
		id_r[ai] = i; // map alphabeta to row id
		
	} 
}


int calculateDLScoreReverse( int *Mseq, int *Nseq, int m, int n, int** DDD, int *id_r)
{
	int id_c; // DDD: full score matrix, id_r: mapping alpha to latest row id, id_c: mapping alpha to latest column id
	int i, j, k, l;
	int temp, swap, up, diag, left; //left: insert, up: delete, diag: Match
	int ai, bj, cmp; // position in subMatrix;  
	int *r, *r1, *p; //private pointer

	 
	
	// Initialize the first row.
	r = DDD[0];
	for( j =0; j <= n; j++)
	{
		r[j] = j; 
	}  
	// calculate other rows
	for( i = 1; i <= m; i++ )
	{
		ai = Mseq[m-i];

		id_c = 0;     // map alphabeta to column id
		
		p = DDD[ai]; // give the space
		r1 = DDD[ai] = r; // save the previous row, this value could not be used
		r = DDD[0] = p; // swap 0 and ai.
		
		diag = i-1; // diag
		r[0] = temp = i; // left
		
		// process each column
		for( j = 1 ; j <= n; j++ )
		{	 
			bj = Nseq[n-j];
			k = id_r[bj]; l = id_c;
			cmp = 0;
			if( ai == bj )
			{
				cmp = 1;
				id_c = j;
			}

			up =  r1[j] +1; // up
			left = temp +1;
			diag += 1-cmp;
			swap = DDD[bj][l-1]+ (i- k -1) + 1 + (j - l - 1);
			r[j] = temp = least( up, left, diag, swap) ;
			 
			diag = up-1;
		}   
		id_r[ai] = i; // map alphabeta to row id
		
	} 
}
 

int calculateDLTrace(int *Mseq, int *Nseq, int m, int n, int* path, int pi, int pj, int transpose)
{
	int d = 0;
	int i,j, k, l, k2, kai;
	int **DDD1, **DDD2, *id_r1, *id_r2, *id_c;
	int **DDDSP1, **DDDSP2, *r;
	int minScore, temp, maxdist;
	int ai, bj;
	int si1, sj1, si2, sj2; 
	
	if( m < n )
	{
		calculateDLTrace( Nseq, Mseq, n, m, path, pj, pi, 1- transpose);
	}
	else if( n == 0  )
	{ 
	}
	else if( n == 1)
	{
		bj = (int) Nseq[1-1] ;  
		for( i =1; i <= m; i++ )
		{
			temp = (bj == Mseq[i-1])?1:0; // find matched
			if( temp )
			{
				break;
			} 
		}
		(i > m) && (i = m); // reset i

		if (transpose)
		{
			if (i > 1) { path[pj+pi+i-1] = pj;  }
			if (i < m) { path[pj + 1 + pi + i] = pj+1; }
		}
		else 
		{
			if (i > 1) { path[pi + i - 1+pj] = pi+i-1; 	}
			if (i < m) { path[pi + i+pj+1] = pi+i; }
		}
		//return path;
	}
	else
	{
		si1 = si2 = m/2; // cut by middle row

		maxdist = m+n+1;
			// Declare space for DDD, id_r, id_c
		DDDSP1 = (int **) calloc( (alphabetaSize+1), sizeof(int*) );
		DDD1 = (int **) calloc( (alphabetaSize+1), sizeof(int*) );
		for(i=0; i <alphabetaSize+1; i++)
		{
			DDDSP1[i] = (int*) calloc( (n+2), sizeof(int) );  // set as 0
			DDD1[i] = DDDSP1[i]+1;
			 
			r = DDDSP1[i];
			for(j = 0 ; j <n+2; j++)
			{
				r[j] = maxdist;
			} 
		}
		id_r1 = (int*) calloc ( (alphabetaSize+1), sizeof(int) ); 
		
		DDDSP2 = (int **) calloc( (alphabetaSize+1), sizeof(int*) );
		DDD2 = (int **) calloc( (alphabetaSize+1), sizeof(int*) );
		for(i=0; i <alphabetaSize+1; i++)
		{
			DDDSP2[i] = (int*) calloc( (n+2), sizeof(int) );  // set as 0
			DDD2[i] = DDDSP2[i]+1;
			 
			r = DDDSP2[i];
			for(j = 0 ; j <n+2; j++)
			{
				r[j] = maxdist;
			} 
		}
		id_r2 = (int*) calloc ( (alphabetaSize+1), sizeof(int) ); 
		 
		calculateDLScore( Mseq, Nseq, si1, n, DDD1, id_r1);
		calculateDLScoreReverse( Mseq+si1, Nseq, m-si1, n, DDD2, id_r2);
		 
		// find the middle pointer
		sj1 = sj2 =0; 
		minScore = DDD1[0][0] +DDD2[0][n];
		for( j =1 ; j<=n; j++)
		{
			temp = DDD1[0][j]+DDD2[0][n-j];
			if(temp < minScore)
			{
				minScore = temp;
				sj1 = sj2 = j;
			}
		}
		for( i=0; i < alphabetaSize; i++)
		{
			ai = alpha[i];	
			kai = m+1 - id_r2[ai]; // ai row in bottome 
			if( kai > m) // this alphabeta is not exist
				continue;
				
			id_c = (int*)calloc(alphabetaSize + 1, sizeof(int));
			j = 1;
			bj = Nseq[0];
			id_c[bj] = j;
		 
			for( j =2 ; j<=n; j++)
			{
				bj = Nseq[j-1];
				k = id_r1[bj]; // row of previous
				l = id_c[ai]; // col of previous
				k2 = m+1 - id_r2[bj]; // row next strip
				
				if( ai != bj && k && l && k2 >= kai ) // make sure the previous row is in the top
				{ 
					temp = DDD1[bj][l-1] + ( kai-k-1)+1+(j-l-1) + DDD2[ai][n-j];
					if(temp < minScore)
					{

						minScore = temp;
						si1 = k-1;
						si2 = kai;
						sj1 = l-1;
						sj2 = j;
					}
				}
				id_c[bj] = j;
			}
		} 

		// save middle pointer
		if( sj1 == sj2)
		{
			if (transpose)
			{
				path[pj + sj1+ pi + si1] = pj+sj1;
			}
			else
			{
				path[pi + si1+ pj + sj1] = pi+si1;
			}
		}
		else
		{
			if (transpose)
			{
				path[ pj + sj1 + pi + si1 ] = pj+sj1;
				path[ pj + sj2 + pi + si2 ] = pj+sj2;
			}
			else
			{
				path[ pi + si1+ pj + sj1] = pi+si1;
				path[ pi + si2+ pj + sj2] = pi+si2;
			}
		}
	
		calculateDLTrace( Mseq, Nseq, si1, sj1, path, pi, pj, transpose);
		calculateDLTrace( Mseq+si2, Nseq+sj2, m-si2, n-sj2, path, pi+si2, pj+sj2, transpose);
	}
	return minScore;
}

