// Linear DL distance score algorithm
// Input: Mseq, Nseq, size m, n

#define min(a,b) (a<b?a:b)
#define least(a,b,c,d) (min( min(a,b), min(c,d) ) )

extern int alphabetaSize;
  
int calculateDLScore( int *Mseq, int *Nseq, int m, int n)
{
	int **DDDSP, maxdist;
	int **DDD, *id_r, id_c; // DDD: full score matrix, id_r: mapping alpha to latest row id, id_c: mapping alpha to latest column id
	int i, j, k, l;
	int temp, swap, up, diag, left; //left: insert, up: delete, diag: Match
	int ai, bj, cmp; // position in subMatrix;  
	int *r, *r1, *p; //private pointer
	 
	maxdist = m+n+1;
	
	// Declare space for DDD, id_r, id_c
	DDDSP = (int **) calloc( (alphabetaSize+1), sizeof(int*) );
	DDD = (int **) calloc( (alphabetaSize+1), sizeof(int*) );
	for(i=0; i <alphabetaSize+1; i++)
	{
		DDDSP[i] = (int*) calloc( (n+2), sizeof(int) );  // set as 0
		DDD[i] = DDDSP[i]+1;
		 
		r = DDDSP[i];
		for(j = 0 ; j <n+2; j++)
		{
			r[j] = maxdist;
		} 
	}
	
	id_r = (int*) calloc ( (alphabetaSize+1), sizeof(int) ); 
	
	// Initialize the first row.
	r = DDD[0];
	for( j =0; j <= n; j++)
	{
		r[j] = j;
	}
	
	// calculate other rows
	for( i = 1; i <= m; i++ )
	{
		ai = Mseq[i-1];

		id_c = 0;     // map alphabeta to column id
		
		p = DDD[ai]; // give the space
		DDD[ai] = r1 = r; // save the previous row, this value could not be used
		r = p; // new current row.

		diag = i-1; // diag
		r[0] = temp = i; // left
		
		// process each column
		for( j = 1 ; j <= n; j++ )
		{
			bj = Nseq[j-1];
			k = id_r[bj]; l = id_c;
			
			cmp = 0;
			if( ai == bj )
			{
				cmp = 1;
				id_c = j;
			} 
			up =  r1[j] +1; // up
			left = temp +1;
			diag += 1-cmp;
			swap = DDD[bj][l-1]+ (i- k -1) + 1 + (j - l - 1);
			r[j] = temp = least( up, left, diag, swap) ;
			
			 
			diag = up-1; 
		} 

		id_r[ai] = i; // map alphabeta to row id		
	}
	return r[n];
}
 