%Code for Compact Image Representation/Compression using Sparse Tensor Projections onto Exemplar Orthonormal Bases, (version %0.0.1):
%----------------------------------------------------
% Copyright (C) 2009 Karthik Gurumoorthy, Ajit Rajwade, Arunava Banerjee and Anand Rangarajan
% 
% Authors: Karthik Gurumoorthy, Ajit Rajwade, Arunava Banerjee and Anand Rangarajan
% Date:    19th Nov 2009
% 
% Contact Information:
%
%Karthik Gurumoorthy: ksg@cise.ufl.edu
% Ajit Rajwade:	avr@cise.ufl.edu
% Arunava Banerjee: arunava@cise.ufl.edu
% Anand Rangarajan: anand@cise.ufl.edu
%
% Terms:	  
% 
% The source code is provided under the
% terms of the GNU General Public License (version 2).
%


function Y = sparsify(X,T)
    dim_X = size(X);
    numElem_X = prod(dim_X);
    oneDim_X = reshape(X,1,numElem_X);
    [sortVec IX] = sort(abs(oneDim_X));
    oneDim_X(IX(1:numElem_X-T)) = 0;
    Y = reshape(oneDim_X,dim_X);
end
    
