%Code for Compact Image Representation/Compression using Sparse Tensor Projections onto Exemplar Orthonormal Bases, (version %0.0.1):
%----------------------------------------------------
% Copyright (C) 2009 Karthik Gurumoorthy, Ajit Rajwade, Arunava Banerjee and Anand Rangarajan
% 
% Authors: Karthik Gurumoorthy, Ajit Rajwade, Arunava Banerjee and Anand Rangarajan
% Date:    19th Nov 2009
% 
% Contact Information:
%
%Karthik Gurumoorthy: ksg@cise.ufl.edu
% Ajit Rajwade:	avr@cise.ufl.edu
% Arunava Banerjee: arunava@cise.ufl.edu
% Anand Rangarajan: anand@cise.ufl.edu
%
% Terms:	  
% 
% The source code is provided under the
% terms of the GNU General Public License (version 2).
%


function resizeImage(imgDirectory,ext,outputDirectory)
    dirName = strcat(imgDirectory,'/*.',ext);
    files = dir(dirName);
    for numImg = 1:length(files)
        imgName = strcat(imgDirectory,'/',files(numImg).name);
        imgData = double(imread(imgName));
        [rows,cols,width] = size(imgData);
        newRowSize = floor(rows/2);
        newColSize = floor(cols/2);
        newImgData = imresize(imgData,[newRowSize newColSize],'bilinear');
        outputFileName = strcat(outputDirectory,'/',files(numImg).name);
        imwrite(newImgData/max(max(max(newImgData))),outputFileName,ext);
    end
end
