%Code for Compact Image Representation/Compression using Sparse Tensor Projections onto Exemplar Orthonormal Bases, (version %0.0.1):
%----------------------------------------------------
% Copyright (C) 2009 Karthik Gurumoorthy, Ajit Rajwade, Arunava Banerjee and Anand Rangarajan
% 
% Authors: Karthik Gurumoorthy, Ajit Rajwade, Arunava Banerjee and Anand Rangarajan
% Date:    19th Nov 2009
% 
% Contact Information:
%
%Karthik Gurumoorthy: ksg@cise.ufl.edu
% Ajit Rajwade:	avr@cise.ufl.edu
% Arunava Banerjee: arunava@cise.ufl.edu
% Anand Rangarajan: anand@cise.ufl.edu
%
% Terms:	  
% 
% The source code is provided under the
% terms of the GNU General Public License (version 2).
%


function [X,DS,N] = HOgetPatchesFromMultipleImages(imgDirectory,patchSize,ext)
    n = 0;
    dirName = strcat(imgDirectory,'/*.',ext);
    files = dir(dirName);
    N = zeros(1,length(files));
    DS = repmat(struct('startDim1',0,'endDim1',0,'startDim2',0,'endDim2',0), 1,length(files)*144);
    
    for numImg = 1:length(files)
        if mod(numImg,10) == 0, fprintf ('%d\n',numImg);end;
        imgName = strcat(imgDirectory,'/',files(numImg).name);
        imgData = double(imread(imgName));
        dimImage = size(imgData);
        newImageDim = floor(dimImage ./ patchSize).* patchSize;
        newImgData = imresize(imgData,newImageDim(1:2),'bilinear');
        sizeEachDim = newImageDim ./ patchSize;
        numComponents = prod(sizeEachDim);
        N(numImg) = numComponents;
        for j = 1:sizeEachDim(2)
            for k = 1:sizeEachDim(1)
                n = n + 1;
                startDim2 = (j-1)*patchSize(2) + 1;
                endDim2 = j*patchSize(2);
                startDim1 = (k-1)*patchSize(1) + 1;
                endDim1 = k*patchSize(1);
                patch(:,:,:) = newImgData(startDim1:endDim1,startDim2:endDim2,:);
                X(:,:,:,n) = patch;
                DS(n).startDim1 = startDim1;
                DS(n).endDim1 = endDim1;
                DS(n).startDim2 = startDim2;
                DS(n).endDim2 = endDim2;
            end
        end
        clear imgData newImgData imgName;
    end
end
        
    
