%Code for Compact Image Representation/Compression using Sparse Matrix Projections onto Exemplar Orthonormal Bases, (version %0.0.1):
%----------------------------------------------------
% Copyright (C) 2009 Karthik Gurumoorthy, Ajit Rajwade, Arunava Banerjee and Anand Rangarajan
% 
% Authors: Karthik Gurumoorthy, Ajit Rajwade, Arunava Banerjee and Anand Rangarajan
% Date:    19th Nov 2009
% 
% Contact Information:
%
%Karthik Gurumoorthy: ksg@cise.ufl.edu
% Ajit Rajwade:	avr@cise.ufl.edu
% Arunava Banerjee: arunava@cise.ufl.edu
% Anand Rangarajan: anand@cise.ufl.edu
%
% Terms:	  
% 
% The source code is provided under the
% terms of the GNU General Public License (version 2).
%



function [U,V] = mixtureSVD(X,rankVec,M,T,str_uv)     
    u_fileName = strcat('U',str_uv);
    v_fileName = strcat('V',str_uv);
    [rows,cols,N] = size(X);
    rank_u = rankVec(1);
    rank_v = rankVec(2);
    numOfOuterIter = 100;
    numOfInnerIter = 5;
    Mia = double(zeros(N,M));
    randMatrix = randn(rows,cols);
    [U_rand S_rand V_rand] = svd(randMatrix);
    randMatrix1 = U_rand(:,1:rank_u);
    randMatrix2 = V_rand(:,1:rank_v);
    %Initial values for Ua and Va %
     U = repmat(randMatrix1,[1 1 M]) + 0.01 * rand(rows,rank_u,M);
     V = repmat(randMatrix2,[1 1 M]) + 0.01 * rand(cols,rank_v,M);
     beta = 0.01;
     for outerIter = 1:numOfOuterIter
        beta = beta * 1.2;
        for innerIter  = 1:numOfInnerIter
            term1 = double(zeros(rows,rank_u,M));
            term2 = double(zeros(cols,rank_v,M));
            %Setting the values of Sia and Mia%
            for i = 1:N
                traceValues = zeros(1,M);
                S = double(zeros([rank_u rank_v M]));
                for a = 1:M
                    S(:,:,a) = U(:,:,a)'*X(:,:,i)*V(:,:,a);
                    tempVec = reshape(S(:,:,a),1,rank_u*rank_v);
                    [sortVec IX] = sort(abs(tempVec));
                    tempVec(IX(1:rank_u*rank_v-T)) = 0;
                    S(:,:,a) = reshape(tempVec,rank_u,rank_v);
                    errorMat = X(:,:,i)-U(:,:,a)*S(:,:,a)*V(:,:,a)';
                    traceValues(a) = norm(errorMat,'fro')^2;
                end
                for a = 1:M
                    Dr = sum(exp(beta *(traceValues(a)-traceValues)));
                    Mia(i,a) = 1/Dr;
                    term1(:,:,a) = term1(:,:,a) + Mia(i,a)*X(:,:,i)*V(:,:,a)*S(:,:,a)';
                    term2(:,:,a) = term2(:,:,a) + Mia(i,a)*X(:,:,i)'*U(:,:,a)*S(:,:,a);
                end
                %fprintf('Patch Number...%d\n',i);
            end
            for a = 1:M
                [U1,S1,V1] = svd(term1(:,:,a));
                [U2,S2,V2] = svd(term2(:,:,a));
                U(:,:,a) = U1*V1';
                V(:,:,a) = U2*V2';
            end
            fprintf('Inner Iteration Number...%d\n',innerIter);
        end
        disp(Mia);
        fprintf('Outer Iteration Number...%d\n',outerIter);
        delete(strcat(u_fileName,'.mat'));
        delete(strcat(v_fileName,'.mat'));
        save(u_fileName,'U');
        save(v_fileName,'V');
     end
end
