%Code for Compact Image Representation/Compression using Sparse Tensor Projections onto Exemplar Orthonormal Bases, (version %0.0.1):
%----------------------------------------------------
% Copyright (C) 2009 Karthik Gurumoorthy, Ajit Rajwade, Arunava Banerjee and Anand Rangarajan
% 
% Authors: Karthik Gurumoorthy, Ajit Rajwade, Arunava Banerjee and Anand Rangarajan
% Date:    19th Nov 2009
% 
% Contact Information:
%
%Karthik Gurumoorthy: ksg@cise.ufl.edu
% Ajit Rajwade:	avr@cise.ufl.edu
% Arunava Banerjee: arunava@cise.ufl.edu
% Anand Rangarajan: anand@cise.ufl.edu
%
% Terms:	  
% 
% The source code is provided under the
% terms of the GNU General Public License (version 2).
%


function HOtest(U_1,U_2,U_3,patchSize,testImgDirectory,str,errTh,fracBit,ext)
    patchSize_prod = prod(patchSize);
    numOfDim = length(patchSize);
    dirName = strcat(testImgDirectory,'/*.',ext);
    files = dir(dirName);
    error = zeros(1,length(files));
    psnr = zeros(1,length(files));
    R = zeros(1,length(files));
    avgCoeffs = zeros(1,length(files));
    q_frac = quantizer('ufixed', 'round', 'saturate', [fracBit+1 fracBit]);
    M = size(U,3);
    symbols = 1:patchSize_prod;
    symbols_Clus = 1:M;
    rangeVal = ceil(sqrt(patchSize_prod));
    symbols_IntVals = -rangeVal:rangeVal;
    minMat = -rangeVal*ones(patchSize);
    maxMat = rangeVal*ones(patchSize);
    for numImg = 1:length(files)
        nonZeroLocations = zeros(1,patchSize_prod);
        numStorage = zeros(1,patchSize_prod);
        clusterNum = zeros(1,M);
        Num_IntVal = zeros(1,rangeVal*2+1);
        testImgName = strcat(testImgDirectory,'/',files(numImg).name);
        [X,DS,originalImg] = HOgetImagePatches(testImgName,patchSize);
        maxPixelVal = max(max(max(originalImg)));
        originalImg = originalImg/maxPixelVal;
        X = X / maxPixelVal;
        imageDim = size(originalImg);
        constructedImg = zeros(imageDim);
        N = size(X,numOfDim+1);
        storage = zeros(1,N);
        for i = 1:N
            errorMat = zeros(1,M);
            index = zeros(1,M);
            S = zeros([patchSize M]);
            %Getting hold of the ith data%
            data_i = X(:,:,:,i);
            for a = 1:M
                tempMatrix = data_i;
                %Projecting data on to the ath cluster%
                tempMatrix = multiply(tempMatrix,U_1(:,:,a)',1);
                tempMatrix = multiply(tempMatrix,U_2(:,:,a)',2);
                tempMatrix = multiply(tempMatrix,U_3(:,:,a)',3);
                tempVec = reshape(tempMatrix,1,patchSize_prod);
                sparseVec = zeros(1,patchSize_prod);
                [sortVec IX] = sort(abs(tempVec),'descend');
                avgPatchError = sum(sum(sum(data_i.^2)))/patchSize_prod;
                while((avgPatchError>errTh) && (index(a)<patchSize_prod))
                    index(a) = index(a) + 1;
                    pos = IX(index(a));
                    sparseVec(pos) = tempVec(pos);
                    avgPatchError = avgPatchError - (tempVec(pos)^2/patchSize_prod);
                    %fprintf('PatchError...%f\n',avgPatchError);
                end
                tempMatrix = reshape(sparseVec,patchSize);
                S(:,:,:,a) = tempMatrix;
                %Reconstructing the data using the basis of the current
                %cluster
                tempMatrix = multiply(tempMatrix,U_1(:,:,a),1);
                tempMatrix = multiply(tempMatrix,U_2(:,:,a),2);
                tempMatrix = multiply(tempMatrix,U_3(:,:,a),3);
                errorMat(a) = sum(sum(sum((data_i - tempMatrix).^2)));
                clear tempVec;
            end
            [numZeros a] = min(index);
            if(numZeros == patchSize_prod)
                %fprintf('This error cannot be reached....\n');
                [errorVal a] = min(errorMat);
            end
            clusterNum(a) = clusterNum(a) + 1;
            Sa = S(:,:,:,a);
            Sa = max(minMat,Sa);
            Sa = min(maxMat,Sa);
            S_int = floor(Sa);
            temp_int = reshape(S_int,1,patchSize_prod);
            S_frac = Sa - S_int;
            coded_S_frac = quantize(q_frac,S_frac);
            coded_S = S_int + coded_S_frac;
            tempVec = reshape(coded_S,1,patchSize_prod);
            nonZeroLoc = find(tempVec);
            nonZero_Int = temp_int(nonZeroLoc);
            unique_Ele = unique(nonZero_Int);
            for len = 1:length(unique_Ele)
                position = find(nonZero_Int==unique_Ele(len));
                Num_IntVal(unique_Ele(len)+rangeVal+1) = Num_IntVal(unique_Ele(len)+rangeVal+1)+length(position);
                clear position;
            end
            clear unique_Ele temp_int;
            storageReqd = length(nonZeroLoc);
            storage(i) = storageReqd;
            %Huffmann encoding
            if(storageReqd~=0)
                nonZeroLocations(nonZeroLoc) = nonZeroLocations(nonZeroLoc) + 1;
                numStorage(storageReqd) =  numStorage(storageReqd) + 1;
            end
            %Reconstructing the data using the basis of the current cluster
            coded_S = multiply(coded_S,U_1(:,:,a),1);
            coded_S = multiply(coded_S,U_2(:,:,a),2);
            coded_S = multiply(coded_S,U_3(:,:,a),3);
            startDim1 = DS(i).startDim1;
            endDim1 = DS(i).endDim1;
            startDim2 = DS(i).startDim2;
            endDim2 = DS(i).endDim2;
            constructedImg(startDim1:endDim1,startDim2:endDim2,:) = coded_S;
            clear  S;
            %fprintf('Storage Required = %f...Error = %f\n',storageReqd,(norm(X(:,:,i)-Z(:,:,i),'fro')^2)/patchSize_prod);
            %pause();
        end
        diffImg = abs(originalImg - constructedImg);
        error(numImg) = sum(sum(sum(diffImg.^2)))/prod(imageDim);
        psnr(numImg) = 10*log10(1/error(numImg));
        %fprintf('Error Value...%f\n',error);
        avgStorageForImg = mean(storage);
        p_b = nonZeroLocations / sum(nonZeroLocations);
        p_a = numStorage / sum(numStorage);
        p_c = clusterNum / sum(clusterNum);
        p_d = Num_IntVal / sum(Num_IntVal);
        set(0,'RecursionLimit',1000);
        [huffmanndict_b b] =  huffmandict(symbols,p_b);
        [huffmanndict_a a] =  huffmandict(symbols,p_a);
        [huffmanndict_c c] =  huffmandict(symbols_Clus,p_c);
        [huffmanndict_d d] =  huffmandict(symbols_IntVals,p_d);
        fprintf('Value of d = %f\n',d);
        numCoeffs = sum(storage);
        numPixels = N*patchSize_prod;
        R(numImg) = ((a+c)*N + numCoeffs*(b+d+fracBit))/numPixels;
        fprintf('imgName = %s.....error = %f...psnr = %f...R = %f\n',testImgName,error(numImg),psnr(numImg),R(numImg));
        fprintf('Average storage per patch for this img...%f\n',avgStorageForImg);
        avgCoeffs(numImg) = avgStorageForImg;
        %constructedImg = constructedImg* maxPixelVal;
        %imwrite(uint8(constructedImg),'ORL_12_1_0003_20.pgm','pgm');
        clear X originalImg constructedImg diffImg DS S; 
    end
    avgR = mean(R);
    avgPSNR = mean(psnr);
    avgCoeff_AllImages = mean(avgCoeffs);
    avg_Vals = [avgR avgPSNR avgCoeff_AllImages];
    fprintf('Avg R = %f....Avg PSNR = %f...Avg Coeff = %f\n',avgR,avgPSNR,avgCoeff_AllImages);
    %disp(psnr');
    errorFileName = strcat('Error',str);
    %save(errorFileName,'error');
    psnrFileName = strcat('PSNR',str);
    %save(psnrFileName,'psnr');
    RFileName = strcat('R',str);
    %save(RFileName,'R');
    avgCoeffFileName = strcat('avgCoeff',str);
    %save(avgCoeffFileName,'avgCoeffs');
    avgValsFileName = strcat('avgVals',str);
    save(avgValsFileName,'avg_Vals');
end
